
-- ----------------------------
-- Table structure for com_city_code
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_city_code`
(
    `id`                 bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `area_name`          varchar(40) NOT NULL COMMENT '区域名称',
    `area_code`          varchar(40) NOT NULL COMMENT '区域代码',
    `area_type`          varchar(40)  DEFAULT NULL COMMENT '区域类型',
    `short_name`         varchar(40)  DEFAULT NULL COMMENT '区域简称',
    `english_name`       varchar(40)  DEFAULT NULL COMMENT '英文名称',
    `area_level`         varchar(40)  DEFAULT NULL COMMENT '区域等级',
    `pid`                bigint(20)  NOT NULL COMMENT '上级ID',
    `area_status`        varchar(40)  DEFAULT NULL COMMENT '地址状态',
    `area_spell`         varchar(40)  DEFAULT NULL COMMENT '汉语拼音',
    `area_shspell`       varchar(40)  DEFAULT NULL COMMENT '拼音首字母',
    `tel_head`           varchar(40)  DEFAULT NULL COMMENT '区号',
    `zip_code`           varchar(40)  DEFAULT NULL COMMENT '邮编',
    `area_desc`          varchar(255) DEFAULT NULL COMMENT '区域描述',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_area_area_code` (`area_code`) USING BTREE,
    INDEX `idx_area_pid` (`pid`) USING BTREE,
    INDEX `idx_area_area_name` (`area_name`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '区域定义';

-- ----------------------------
-- Table structure for com_curr
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_curr`
(
    `id`                 bigint(20) NOT NULL DEFAULT 0 COMMENT '唯一编号ID',
    `curr_code`          varchar(40)         DEFAULT NULL COMMENT '币种代码',
    `curr_name`          varchar(40)         DEFAULT NULL COMMENT '币种名称',
    `disp_decimal`       int(11)             DEFAULT NULL COMMENT '显示小数位数',
    `enable_flag`        int(11)             DEFAULT NULL COMMENT '是否有效',
    `tenant_id`          bigint(20)          DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)        DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)          DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime            DEFAULT NULL,
    `modify_user_id`     bigint(20)          DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime            DEFAULT NULL,
    `delete_flag`        int(11)             DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)             DEFAULT NULL COMMENT '版本信息，前端不用传',
    `creator`            varchar(255)        DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)        DEFAULT NULL COMMENT '记录最后更新者',
    `ou_id`              bigint(20)          DEFAULT NULL COMMENT '公司ID',
    `sec_bu_id`          bigint(20)          DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)          DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)          DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_curr_code` (`curr_code`) USING BTREE,
    INDEX `curr_code` (`curr_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '币种';

-- ----------------------------
-- Table structure for com_curr_rate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_curr_rate`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `ou_id`              int(11)      DEFAULT NULL COMMENT '公司ID',
    `rate_type`          varchar(40)  DEFAULT NULL COMMENT '汇率类型',
    `rate_type2`         varchar(40)  DEFAULT NULL COMMENT '汇率类型2',
    `rate_type3`         varchar(40)  DEFAULT NULL COMMENT '汇率类型3',
    `rate_status`        varchar(40)  DEFAULT NULL COMMENT '汇率状态',
    `rate_status2`       varchar(40)  DEFAULT NULL COMMENT '汇率状态2',
    `rate_source`        varchar(40)  DEFAULT NULL COMMENT '汇率来源',
    `from_curr`          varchar(40)  DEFAULT NULL COMMENT '从币种',
    `to_curr`            varchar(40)  DEFAULT NULL COMMENT '到币种',
    `cal_method`         varchar(40)  DEFAULT NULL COMMENT '计算方法',
    `ratio`              float(20, 8) DEFAULT NULL COMMENT '汇率',
    `ratio2`             float(20, 8) DEFAULT NULL COMMENT '汇率2',
    `ratio3`             float(20, 2) DEFAULT NULL COMMENT '汇率3',
    `valid_from`         datetime     DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     DEFAULT NULL COMMENT '失效日期',
    `period_id`          int(11)      DEFAULT NULL COMMENT '期间ID',
    `tenant_id`          bigint(20)   DEFAULT 0 COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT '' COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT 0 COMMENT '记录创建者ID',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT 0 COMMENT '记录最后更新者ID',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT 0 COMMENT '版本信息，前端不用传',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE
) COMMENT = '汇率';

-- ----------------------------
-- Table structure for com_district
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_district`
(
    `id`                 bigint(20)    NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `dist_code`          varchar(32)   NOT NULL DEFAULT '' COMMENT '区划代码',
    `dist_name`          varchar(64)   NOT NULL DEFAULT '' COMMENT '区划名称',
    `dist_name2`         varchar(64)   NOT NULL DEFAULT '' COMMENT '区划名称2',
    `dist_type`          varchar(32)   NOT NULL DEFAULT '' COMMENT '区划类型',
    `dist_type2`         varchar(32)   NOT NULL DEFAULT '' COMMENT '区划类型2',
    `dist_type3`         varchar(32)   NOT NULL DEFAULT '' COMMENT '区划类型33',
    `abbr_name`          varchar(32)   NOT NULL DEFAULT '' COMMENT '区划简称',
    `country`            varchar(32)   NOT NULL DEFAULT '' COMMENT '国家码: COM:COUNTRY',
    `province`           varchar(32)   NOT NULL DEFAULT '' COMMENT '省份、州码：COM:STATE',
    `city`               varchar(32)   NOT NULL DEFAULT '' COMMENT '城市码：COM:CITY',
    `county`             varchar(32)   NOT NULL DEFAULT '' COMMENT '区县码: COM:COUNTY',
    `street`             varchar(128)  NOT NULL DEFAULT '' COMMENT '乡镇街道',
    `dist_level`         varchar(32)   NOT NULL DEFAULT '' COMMENT '区域等级',
    `dist_level_num`     int(11)       NOT NULL DEFAULT 0 COMMENT '区域等级数值',
    `parent_id`          bigint(20)    NOT NULL DEFAULT 0 COMMENT '上级ID',
    `parent_code`        varchar(32)   NOT NULL DEFAULT '' COMMENT '上级代码',
    `path`               varchar(1024) NULL     DEFAULT '' COMMENT '路径',
    `dist_status`        varchar(32)   NOT NULL DEFAULT '' COMMENT '地址状态',
    `dist_pinyin`        varchar(256)  NOT NULL DEFAULT '' COMMENT '汉语拼音',
    `dist_pinyin_caps`   varchar(32)   NOT NULL DEFAULT '' COMMENT '拼音首字母',
    `tel_head`           varchar(32)   NOT NULL DEFAULT '' COMMENT '电话区号',
    `zip_code`           varchar(16)   NOT NULL DEFAULT '' COMMENT '邮编',
    `dist_desc`          varchar(256)  NOT NULL DEFAULT '' COMMENT '区域描述',
    `es1`                varchar(64)   NOT NULL DEFAULT '' COMMENT '扩展字符串1',
    `es2`                varchar(64)   NOT NULL DEFAULT '' COMMENT '扩展字符串2',
    `es3`                varchar(64)   NOT NULL DEFAULT '' COMMENT '扩展字符串3',
    `tenant_id`          bigint(20)    NOT NULL DEFAULT 0 COMMENT '租户ID',
    `remark`             varchar(255)  NOT NULL DEFAULT '' COMMENT '备注',
    `create_user_id`     bigint(20)    NOT NULL DEFAULT 0 COMMENT '记录创建者ID',
    `create_time`        datetime               DEFAULT NULL,
    `modify_user_id`     bigint(20)    NOT NULL DEFAULT 0 COMMENT '记录最后更新者ID',
    `modify_time`        datetime               DEFAULT NULL,
    `delete_flag`        int(11)       NOT NULL DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       NOT NULL DEFAULT 0 COMMENT '版本信息，前端不用传',
    `p_id`               bigint(20)    NOT NULL DEFAULT 0 COMMENT '上级ID',
    `p_code`             varchar(32)   NOT NULL DEFAULT '' COMMENT '上级代码',
    `creator`            varchar(255)           DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255)           DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)             DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)             DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)             DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `dist_code` (`dist_code`) USING BTREE,
    INDEX `dist_code_2` (`dist_code`, `dist_level_num`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '行政区划';

-- ----------------------------
-- Table structure for com_payment_term
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_payment_term`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pt_code`            varchar(40)  DEFAULT NULL COMMENT '代码',
    `pt_name`            varchar(40)  DEFAULT NULL COMMENT '名称',
    `days`               int(11)      DEFAULT NULL COMMENT '天数',
    `base_day_type`      varchar(40)  DEFAULT NULL COMMENT '基于日期类型',
    `day_calc_method`    varchar(40)  DEFAULT NULL COMMENT '日期计算方式 是否含工作日',
    `valid_from`         datetime     DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     DEFAULT NULL COMMENT '失效日期',
    `enable_flag`        int(11)      DEFAULT 0 COMMENT '是否有效',
    `account_code`       varchar(40)  DEFAULT NULL COMMENT '对账报账编码',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '支付条款 币种 此表使用CODE来引用，不使用ID。';

-- ----------------------------
-- Table structure for com_tax_code
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_tax_code`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `tax_name`           varchar(40)  DEFAULT NULL COMMENT '税区/税码',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `tax_type`           varchar(40)  DEFAULT NULL COMMENT '税区',
    `tax_code`           varchar(40)  DEFAULT NULL COMMENT '税码',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE
) COMMENT = '税码';

-- ----------------------------
-- Table structure for com_tax_rate
-- ----------------------------
CREATE TABLE IF NOT EXISTS `com_tax_rate`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '唯一编号ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `tax_rate_no`        varchar(40)  DEFAULT NULL COMMENT '税率编号',
    `tax_rate_desc`      varchar(40)  DEFAULT NULL COMMENT '税率说明',
    `valid_from`         datetime     DEFAULT NULL COMMENT '生效日期',
    `valid_to`           datetime     DEFAULT NULL COMMENT '失效日期',
    `tax_rate_value`     float(20, 8) DEFAULT NULL COMMENT '税率值',
    `tenant_id`          bigint(20)   DEFAULT 0 COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT '' COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT 0 COMMENT '记录创建者ID',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT 0 COMMENT '记录最后更新者ID',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT 0 COMMENT '版本信息，前端不用传',
    `tax_rate_index`     varchar(40)  DEFAULT NULL COMMENT '税率索引 [UOM]COM:TAX_RATE_INDEX',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `tax_rate_no` (`tax_rate_no`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '税率';

-- ----------------------------
-- Table structure for common_org_bu_treed
-- ----------------------------
CREATE TABLE IF NOT EXISTS `common_org_bu_treed`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(20) NOT NULL COMMENT '上级ID',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `level`              int(11)      DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `bu_tree_id`         bigint(20)   DEFAULT NULL COMMENT '组织树ID',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT '组织ID',
    `bu_code`            varchar(40)  DEFAULT NULL,
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_bu_tree_pid` (`pid`) USING BTREE,
    INDEX `idx_bu_tree_code_path` (`code_path`) USING BTREE
) COMMENT = '组织树明细';

-- ----------------------------
-- Table structure for common_org_emp
-- ----------------------------
CREATE TABLE IF NOT EXISTS `common_org_emp`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `pid`                bigint(20) NOT NULL COMMENT '上级ID',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `level`              int(11)      DEFAULT NULL COMMENT '层级',
    `code_path`          varchar(255) DEFAULT NULL COMMENT '树型结构编号全路径，使用/隔离',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '公司编号',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT 'BU ID',
    `bu_code`            varchar(40)  DEFAULT NULL COMMENT 'BU编号',
    `bu_name`            varchar(40)  DEFAULT NULL COMMENT 'BU名称',
    `emp_bu_id`          bigint(20)   DEFAULT NULL COMMENT '员工所属 BU ID',
    `emp_bu_tree_id`     bigint(20)   DEFAULT NULL COMMENT '员工所属BU树ID',
    `emp_bu_treedid`     bigint(20)   DEFAULT NULL COMMENT '员工所属BU树详情ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '用户id',
    `user_name`          varchar(40)  DEFAULT NULL COMMENT '用户名',
    `emp_code`           varchar(40)  DEFAULT NULL COMMENT '雇员编号',
    `emp_name`           varchar(40)  DEFAULT NULL COMMENT '雇员姓名',
    `emp_type`           varchar(255) DEFAULT NULL COMMENT '员工类型 [UDC]ORG:EMP_TYPE',
    `emp_type2`          varchar(40)  DEFAULT NULL COMMENT '员工类型2',
    `emp_type3`          varchar(40)  DEFAULT NULL COMMENT '员工类型3',
    `emp_status`         varchar(40)  DEFAULT NULL COMMENT '员工状态 [UDC]ORG:EMP_STATUS',
    `foreign_name`       varchar(40)  DEFAULT NULL COMMENT '雇员外文名',
    `addr_no`            bigint(20)   DEFAULT NULL COMMENT '地址号',
    `emp_gender`         varchar(40)  DEFAULT NULL COMMENT '员工性别',
    `birth_date`         datetime(6)  DEFAULT NULL COMMENT '出生日期',
    `email`              varchar(40)  DEFAULT NULL COMMENT '工作邮箱',
    `mobile`             varchar(40)  DEFAULT NULL COMMENT '工作手机号',
    `id_type`            varchar(40)  DEFAULT NULL COMMENT '证件类型',
    `id_no`              varchar(255) DEFAULT NULL COMMENT '证件号码',
    `emp_level`          varchar(40)  DEFAULT NULL COMMENT '职级',
    `title`              varchar(40)  DEFAULT NULL COMMENT '行政职位, [UDC]ORG:TITLE',
    `join_date`          datetime(6)  DEFAULT NULL COMMENT '入职日期',
    `jdy_flag`           int(11)      DEFAULT 1 COMMENT '是否同步激荡云,默认 1 ',
    `leave_date`         datetime(6)  DEFAULT NULL COMMENT '离职日期',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_emp_pid` (`pid`) USING BTREE,
    INDEX `idx_emp_code_path` (`code_path`) USING BTREE
) COMMENT = '员工';

-- ----------------------------
-- Table structure for hibernate_sequence
-- ----------------------------
CREATE TABLE IF NOT EXISTS `hibernate_sequence`
(
    `next_val` bigint(20) DEFAULT NULL
);

-- ----------------------------
-- Table structure for rocket_transaction_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `rocket_transaction_log`
(
    `id`             bigint(20)   NOT NULL AUTO_INCREMENT,
    `transaction_id` varchar(100) NOT NULL COMMENT '事务id',
    `doc_code`       varchar(100) DEFAULT NULL COMMENT '文件编号标识',
    `project`        varchar(200) DEFAULT NULL COMMENT '项目标识',
    `business`       varchar(200) DEFAULT NULL COMMENT '业务标识',
    `extend_json`    varchar(200) DEFAULT NULL COMMENT '扩展信息',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_t6h3pd6fijdux5e1fvvrtx99g` (`transaction_id`) USING BTREE
) COMMENT = 'rocketmnq事务日志';

-- ----------------------------
-- Table structure for sys_biz_constraint
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_biz_constraint`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `data_role_code`     varchar(255) DEFAULT NULL COMMENT '数据角色编码',
    `data_role_name`     varchar(255) DEFAULT NULL COMMENT '数据角色名称',
    `domain_code`        varchar(255) DEFAULT NULL COMMENT '领域编码',
    `domain_name`        varchar(255) DEFAULT NULL COMMENT '领域名称',
    `table_code`         varchar(255) DEFAULT NULL COMMENT '表编码',
    `table_name`         varchar(255) DEFAULT NULL COMMENT '表名称',
    `field_code`         varchar(255) DEFAULT NULL COMMENT '表字段编码',
    `field_caption`      varchar(255) DEFAULT NULL COMMENT '字段名称',
    `field_type`         varchar(255) DEFAULT NULL COMMENT '字段类型',
    `udc_domain_code`    varchar(255) DEFAULT NULL COMMENT 'UDC的Domain Code',
    `udc_code`           varchar(255) DEFAULT NULL COMMENT 'UDC的UDC Code',
    `default_value`      varchar(255) DEFAULT NULL COMMENT '默认值',
    `compare_op_code`    varchar(255) DEFAULT NULL COMMENT '比较符编码',
    `compare_op_name`    varchar(255) DEFAULT NULL COMMENT '比较符名称',
    `constraint_values`  varchar(255) DEFAULT NULL COMMENT '约束值, 多值采用逗号分隔',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `field_udc_type`     varchar(255) DEFAULT NULL COMMENT '逻辑UDC字段类型META:FLDTYPE',
    `meta_column_id`     bigint(20)   DEFAULT NULL COMMENT '元数据列的记录ID',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '业务数据权限约束';

-- ----------------------------
-- Table structure for sys_butable
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_butable`
(
    `id`           bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
    `butable_name` varchar(128) DEFAULT NULL COMMENT '表名称',
    `use_null`     int(1)       DEFAULT NULL COMMENT '是否可以使用空值 1:可以 0:不可以',
    `delete_flag`  int(1)       DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '配置bu权限表';

-- ----------------------------
-- Table structure for sys_data_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_data_role`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(40) NOT NULL COMMENT '数据角色代码',
    `name`               varchar(40) NOT NULL COMMENT '数据角色名称',
    `advanced_enable`    int(11)     NOT NULL COMMENT '是否取用高级授权',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `business_enable`    int(11)      DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_cem7cq6iwip27be1ik1724rtq` (`code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统数据角色表';

-- ----------------------------
-- Table structure for sys_data_role_auth
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_data_role_auth`
(
    `id`                   bigint(20) NOT NULL COMMENT '记录唯一ID',
    `data_role_id`         bigint(20)   DEFAULT NULL COMMENT '关联的数据角色ID',
    `is_basic`             int(11)      DEFAULT NULL COMMENT '是否基础数据授权：1 是，0 否',
    `permission_id`        bigint(20)   DEFAULT NULL COMMENT '高级授权应用ID',
    `permission_code`      varchar(255) DEFAULT NULL COMMENT '高级授权应用Code',
    `is_permit_all`        int(11)    NOT NULL COMMENT '是否全部授权全部数据',
    `emp_auth_enable`      int(11)      DEFAULT NULL COMMENT '是否启用员工授权',
    `emp_auth_scope`       varchar(40)  DEFAULT NULL COMMENT '员工数据权限授权范围',
    `emp_customize_enable` int(11)      DEFAULT NULL COMMENT '员工是否启用自定义授权',
    `bu_auth_enable`       int(11)      DEFAULT NULL COMMENT '是否启用组织授权',
    `bu_auth_scope`        varchar(40)  DEFAULT NULL COMMENT '组织数据权限授权范围',
    `bu_customize_enable`  int(11)      DEFAULT NULL COMMENT '组织是否启用自定义授权',
    `tenant_id`            bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`               varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`       bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`              varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`          datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`       bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`              varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`          datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`          int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version`   int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`            bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`            bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `ou_auth_enable`       int(11)      DEFAULT NULL COMMENT '是否启用公司授权',
    `ou_auth_scope`        varchar(40)  DEFAULT NULL COMMENT '公司数据权限授权范围',
    `ou_customize_enable`  int(11)      DEFAULT NULL COMMENT '公司是否启用自定义授权',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统数据角色授权表';

-- ----------------------------
-- Table structure for sys_data_role_auth_customize
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_data_role_auth_customize`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `data_role_auth_id`  bigint(20)   DEFAULT NULL COMMENT '数据角色授权信息ID',
    `customize_type`     varchar(40)  DEFAULT NULL COMMENT '自定义类型：人员还是组织',
    `sec_id`             bigint(20)   DEFAULT NULL COMMENT '自定义授权数据ID',
    `sec_code`           varchar(40)  DEFAULT NULL COMMENT '自定义授权数据CODE',
    `sec_name`           varchar(40)  DEFAULT NULL COMMENT '自定义授权数据名称',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统数据角色自定义授权表';

-- ----------------------------
-- Table structure for sys_flow_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_flow_role`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_k7iim1lyhuyr06xn6jdj8vei1` (`code`) USING BTREE
) COMMENT = '流程角色表';

-- ----------------------------
-- Table structure for sys_front_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_front_config`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '绑定的应用角色ID',
    `permission_id`      bigint(20)   DEFAULT NULL COMMENT '绑定的权限ID',
    `config_code`        varchar(40)  DEFAULT NULL COMMENT '配置编号',
    `config_context`     longtext   NULL COMMENT '配置内容',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_config_code` (`config_code`) USING BTREE
) COMMENT = '前端表单，表格动态配置';

-- ----------------------------
-- Table structure for sys_next_number
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_next_number`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `code`               varchar(255) NOT NULL COMMENT '下一编号代码',
    `name`               varchar(255) NOT NULL COMMENT '下一编号名称',
    `number_class`       varchar(255) DEFAULT NULL COMMENT '下一编号分类',
    `step`               int(11)      DEFAULT NULL COMMENT '下一编号步长',
    `next_number`        bigint(20)   DEFAULT NULL COMMENT '下一编号取值',
    `nn_period`          varchar(255) DEFAULT NULL COMMENT '下一编号周期',
    `nn_time`            datetime(6)  DEFAULT NULL COMMENT '发号时间',
    `version`            int(11)      DEFAULT NULL COMMENT '乐观锁标记',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_s6xdfqu3p37tc3a6gpsc23mq8` (`code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '取号下一编号表';

-- ----------------------------
-- Table structure for sys_number_rule
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_number_rule`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `rule_code`          varchar(255) NOT NULL COMMENT '规则编号',
    `rule_name`          varchar(64)  DEFAULT NULL COMMENT '规则名称',
    `rule_class`         varchar(32)  DEFAULT NULL COMMENT '规则分类码：sys:numrulcls',
    `sample_code`        varchar(255) DEFAULT NULL COMMENT '取号示例',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_3904pugpu38vqwlg4aussvgr1` (`rule_code`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '发号器规则';

-- ----------------------------
-- Table structure for sys_number_ruledtl
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_number_ruledtl`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `rule_id`            bigint(20)   DEFAULT NULL COMMENT '发号器规则ID',
    `seq`                int(11)      DEFAULT NULL COMMENT '排序号',
    `number_type`        varchar(255) DEFAULT NULL COMMENT '取号类型：sys:numbertype',
    `number_pattern`     varchar(255) DEFAULT NULL COMMENT '取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码',
    `nn_len`             int(11)      DEFAULT NULL COMMENT '自增序号宽度，默认左补零',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `idx_sys_number_ruledtl_rule_id` (`rule_id`) USING BTREE
) COMMENT = '发号器规则明细';

-- ----------------------------
-- Table structure for sys_quick_entry
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_quick_entry`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `quick_data`         varchar(1024) DEFAULT NULL COMMENT '快捷入口数据：前端传递，后端直接返回',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)       DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '系统快捷入口配置';

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_fail_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_fail_log`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `type_id`            int(11)       DEFAULT NULL COMMENT '消费失败类型：1：消费次数过多，2：业务异常，3：长时间无法消费,4:其他',
    `already_deal`       varchar(255)  DEFAULT NULL COMMENT '消费失败是否已处理；PROCESSED：已处理，TO_BE_PROCESSED:待处理',
    `consumer_group`     varchar(256)  DEFAULT NULL COMMENT '消费者组',
    `consumer_topic`     varchar(128)  DEFAULT NULL COMMENT '消费主题',
    `message_detail`     varchar(1024) DEFAULT NULL COMMENT '消费数据详情',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)       DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    `consumer_key`       varchar(64)   DEFAULT NULL COMMENT '消息体key',
    `message_uuid`       varchar(255)  DEFAULT NULL COMMENT '消息UUID',
    `consumer_boby`      varchar(5096) DEFAULT NULL COMMENT '消息体',
    `consumer_tag`       varchar(128)  DEFAULT NULL,
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UKgrpk942r3l233crbyf36p0xpx` (`consumer_key`) USING BTREE
) COMMENT = '架构补偿机制-消费失败记录';

-- ----------------------------
-- Table structure for sys_rocket_mq_consume_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_rocket_mq_consume_log`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `line_num`           bigint(20)    DEFAULT NULL COMMENT '消息行号',
    `consumer_kye`       varchar(64)   DEFAULT NULL COMMENT '消息体key',
    `consumer_group`     varchar(256)  DEFAULT NULL COMMENT '消费者组',
    `consumer_topic`     varchar(128)  DEFAULT NULL COMMENT '消费主题',
    `is_success`         int(11)       DEFAULT NULL COMMENT '是否消费成功:true:成功，false:失败',
    `fail_detail`        varchar(255)  DEFAULT NULL COMMENT '失败详情',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)       DEFAULT 0 COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    `queue_id`           int(11)       DEFAULT NULL COMMENT '消息体key',
    `message_id`         varchar(255)  DEFAULT NULL COMMENT '消息标识',
    `reconsume_times`    int(11)       DEFAULT NULL COMMENT '消息标识',
    `consumer_key`       varchar(64)   DEFAULT NULL COMMENT '消息体key',
    `message_uuid`       varchar(255)  DEFAULT NULL COMMENT '消息UUID',
    `message_body`       varchar(1024) DEFAULT NULL COMMENT '消息体',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '架构补偿机制-消费记录';

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role`
(
    `id`                 bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `code`               varchar(16) NOT NULL COMMENT '角色代码',
    `name`               varchar(32) NOT NULL COMMENT '角色名称',
    `enabled`            int(11)      DEFAULT NULL COMMENT '是否启用',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `tenant_name`        varchar(64)  DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `UK_plpigyqwsqfn7mn66npgf9ftp` (`code`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '系统角色表';

-- ----------------------------
-- Table structure for sys_role_ou
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role_ou`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '公司ID',
    `ou_name`            varchar(32) NOT NULL COMMENT '公司名称',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '角色ID',
    `role_name`          varchar(32) NOT NULL COMMENT '角色名称',
    `role_type`          int(11)     NOT NULL COMMENT '角色类型：0：应用角色，1 数据角色  目前仅支持数据角色',
    `username`           varchar(32) NOT NULL COMMENT '用户账号名称',
    `last_name`          varchar(256) DEFAULT NULL COMMENT '用户姓氏',
    `first_name`         varchar(256) DEFAULT NULL COMMENT '用户名称',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '用户Id',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_ajal0xja8q14kapqpgxq9hynj` (`username`) USING BTREE
) COMMENT = '系统角色与公司表';

-- ----------------------------
-- Table structure for sys_role_permission
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role_permission`
(
    `id`                 bigint(20) NOT NULL COMMENT '账号唯一ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '角色ID',
    `permission_id`      bigint(20)   DEFAULT NULL COMMENT '权限ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `idx_role_permission_role` (`role_id`) USING BTREE,
    INDEX `idx_role_permission_permission` (`permission_id`) USING BTREE
) COMMENT = '角色权限关联表';

-- ----------------------------
-- Table structure for sys_role_resources
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_role_resources`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '角色ID',
    `resources_id`       bigint(20)   DEFAULT NULL COMMENT '资源ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '角色资源关联表';

-- ----------------------------
-- Table structure for sys_setting
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_setting`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `setting_no`         varchar(40)  DEFAULT NULL COMMENT '设置编号',
    `setting_name`       varchar(40)  DEFAULT NULL COMMENT '设置名',
    `setting_type`       varchar(40)  DEFAULT NULL COMMENT '设置类型',
    `setting_type2`      varchar(40)  DEFAULT NULL COMMENT '设置类型2',
    `setting_type3`      varchar(40)  DEFAULT NULL COMMENT '设置类型3',
    `setting_status`     varchar(40)  DEFAULT NULL COMMENT '设置状态',
    `setting_desc`       varchar(500) DEFAULT NULL COMMENT '设置描述',
    `setting_val`        varchar(500) DEFAULT NULL COMMENT '设置值',
    `def_val`            varchar(100) DEFAULT NULL COMMENT '默认值',
    `sort_no`            int(11)      DEFAULT NULL COMMENT '排序号',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `email`              varchar(32)  DEFAULT NULL COMMENT '设置类型3',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '设置项';

-- ----------------------------
-- Table structure for sys_udc
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_udc`
(
    `id`                 bigint(20)  NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `domain_code`        varchar(32) NOT NULL COMMENT '领域码',
    `udc_code`           varchar(32) NOT NULL COMMENT 'UDC码',
    `udc_name`           varchar(64)  DEFAULT NULL COMMENT 'UDC码名称',
    `udc_val`            varchar(32) NOT NULL COMMENT 'UDC值',
    `val_desc`           varchar(64) NOT NULL COMMENT '值描述',
    `val_sort_no`        int(11)      DEFAULT NULL COMMENT '排序号',
    `hd_flag`            int(11)      DEFAULT NULL COMMENT '硬编码',
    `dp_flag`            int(11)      DEFAULT NULL COMMENT '是否开启数据权限',
    `es1`                varchar(32)  DEFAULT NULL COMMENT '扩展字段1-特殊处理',
    `es2`                varchar(32)  DEFAULT NULL COMMENT '扩展字段2',
    `es3`                varchar(32)  DEFAULT NULL COMMENT '扩展字段3',
    `es4`                varchar(32)  DEFAULT NULL COMMENT '扩展字段4',
    `es5`                varchar(32)  DEFAULT NULL COMMENT '扩展字段5',
    `es6`                varchar(32)  DEFAULT NULL COMMENT '扩展字段6',
    `es7`                varchar(32)  DEFAULT NULL COMMENT '扩展字段7',
    `es8`                varchar(32)  DEFAULT NULL COMMENT '扩展字段8',
    `ef1`                double       DEFAULT NULL COMMENT '扩展浮点1',
    `ef2`                double       DEFAULT NULL COMMENT '扩展浮点2',
    `ef3`                double       DEFAULT NULL COMMENT '扩展浮点3',
    `ef4`                double       DEFAULT NULL COMMENT '扩展浮点4',
    `ei1`                int(11)      DEFAULT NULL COMMENT '扩展整数1',
    `ei2`                int(11)      DEFAULT NULL COMMENT '扩展整数2',
    `ei3`                int(11)      DEFAULT NULL COMMENT '扩展整数3',
    `ei4`                int(11)      DEFAULT NULL COMMENT '扩展整数4',
    `ed1`                datetime(6)  DEFAULT NULL COMMENT '扩展日期1',
    `ed2`                datetime(6)  DEFAULT NULL COMMENT '扩展日期2',
    `ed3`                datetime(6)  DEFAULT NULL COMMENT '扩展日期3',
    `ed4`                datetime(6)  DEFAULT NULL COMMENT '扩展日期4',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `uk_domain_code_val` (`domain_code`, `udc_code`, `udc_val`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '分类码表';

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user`
(
    `id`                 bigint(20)   NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `username`           varchar(32)  NOT NULL COMMENT '用户账号名称',
    `last_name`          varchar(256)  DEFAULT NULL COMMENT '用户姓氏',
    `first_name`         varchar(256)  DEFAULT NULL COMMENT '用户名称',
    `mobile`             varchar(16)   DEFAULT NULL COMMENT '用户手机号码',
    `email`              varchar(32)   DEFAULT NULL COMMENT '用户邮箱地址',
    `password`           varchar(128) NOT NULL COMMENT '用户账号密码-hashed',
    `source_type`        varchar(32)   DEFAULT NULL COMMENT '账号来源, sys： 系统创建；wec：微信创建；oth：其他方式',
    `enabled`            int(11)       DEFAULT NULL COMMENT '是否启用',
    `trans_flag`         int(11)       DEFAULT 0 COMMENT '是否同步 0 未同步 1 已同步',
    `tenant_id`          bigint(20)    DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255)  DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255)  DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)   DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)    DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255)  DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)   DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)       DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)       DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)    DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)    DEFAULT NULL COMMENT 'sec_ou_id',
    `need_reset`         int(11)       DEFAULT NULL COMMENT '密码是否需要重新设置',
    `wx_openid`          varchar(128)  DEFAULT NULL COMMENT '微信poenid',
    `ou_id`              bigint(20)    DEFAULT NULL COMMENT '用户所属公司ID',
    `ou_code`            varchar(40)   DEFAULT NULL COMMENT '用户所属公司编号',
    `ou_name`            varchar(40)   DEFAULT NULL COMMENT '用户所属公司名称',
    `bu_id`              bigint(20)    DEFAULT NULL COMMENT '用户所属组织ID',
    `avatar_url`         varchar(2048) DEFAULT NULL COMMENT '用户头像地址，可直接访问，如微信头像地址等',
    `avatar_code`        varchar(32)   DEFAULT NULL COMMENT '用户头像在文件服务器中的标识',
    `full_name`          varchar(40)   DEFAULT NULL COMMENT '用户姓名',
    `user_type`          varchar(40)   DEFAULT NULL COMMENT '用户类型',
    `tenant_name`        varchar(65)   DEFAULT NULL COMMENT '所属租户名称',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_51bvuyvihefoh4kp5syh2jpi4` (`username`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `idx_sys_user_mobile` (`mobile`) USING BTREE
) COMMENT = '系统用户账号表';

-- ----------------------------
-- Table structure for sys_user_data_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_data_role`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE
) COMMENT = '用户数据角色关联表';

-- ----------------------------
-- Table structure for sys_user_flow_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_flow_role`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '账号ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '数据角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE
) COMMENT = '用户流程角色关联表';

-- ----------------------------
-- Table structure for sys_user_proxy
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_proxy`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '被代理人id',
    `username`           varchar(32) NOT NULL COMMENT '被代理人用户账号名称',
    `mobile`             varchar(16)  DEFAULT NULL COMMENT '被代理人用户手机号码',
    `email`              varchar(32)  DEFAULT NULL COMMENT '被代理人用户邮箱地址',
    `ou_id`              bigint(20)   DEFAULT NULL COMMENT '被代理人用户所属公司ID',
    `ou_code`            varchar(40)  DEFAULT NULL COMMENT '被代理人用户所属公司编号',
    `ou_name`            varchar(40)  DEFAULT NULL COMMENT '被代理人用户所属公司名称',
    `bu_id`              bigint(20)   DEFAULT NULL COMMENT '被代理人用户所属组织ID',
    `proxy_user_id`      bigint(20)   DEFAULT NULL COMMENT '代理人id',
    `proxy_username`     varchar(32) NOT NULL COMMENT '代理人用户账号名称',
    `proxy_mobile`       varchar(16)  DEFAULT NULL COMMENT '代理人用户手机号码',
    `proxy_email`        varchar(32)  DEFAULT NULL COMMENT '代理人用户邮箱地址',
    `proxy_ou_id`        bigint(20)   DEFAULT NULL COMMENT '代理人用户所属公司ID',
    `proxy_ou_code`      varchar(40)  DEFAULT NULL COMMENT '代理人用户所属公司编号',
    `proxy_ou_name`      varchar(40)  DEFAULT NULL COMMENT '代理人用户所属公司名称',
    `proxy_bu_id`        bigint(20)   DEFAULT NULL COMMENT '代理人用户所属组织ID',
    `open_flag`          int(11)      DEFAULT NULL COMMENT '是否开启-0：开启，1关闭',
    `effect_start_time`  datetime(6)  DEFAULT NULL COMMENT '代理生效开始时间',
    `effect_end_time`    datetime(6)  DEFAULT NULL COMMENT '代理生效结束时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_asmyoj2xbixiyvpymex71uihg` (`username`) USING BTREE,
    UNIQUE INDEX `UK_al4cbi2jpu3dc3128lomq2s88` (`proxy_username`) USING BTREE
) COMMENT = '被代理用户与代理用户关系表';

-- ----------------------------
-- Table structure for sys_user_role
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_role`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '账号唯一ID',
    `user_id`            bigint(20)   DEFAULT NULL COMMENT '用户ID',
    `role_id`            bigint(20)   DEFAULT NULL COMMENT '角色ID',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE,
    INDEX `sec_bu_id_index` (`sec_bu_id`) USING BTREE,
    INDEX `sec_user_id_index` (`sec_user_id`) USING BTREE,
    INDEX `sec_ou_id_index` (`sec_ou_id`) USING BTREE,
    INDEX `idx_sys_user_role_role_id` (`role_id`) USING BTREE,
    INDEX `idx_sys_user_role_user_id` (`user_id`) USING BTREE
) COMMENT = '用户角色关联表';

-- ----------------------------
-- Table structure for sys_user_terminal
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_terminal`
(
    `id`                 bigint(20)  NOT NULL COMMENT '记录唯一ID',
    `user_id`            bigint(20)  NOT NULL COMMENT '用户ID，sys_user.id',
    `terminal_code`      varchar(64) NOT NULL COMMENT '终端编码，Terminal枚举类',
    `time_bind`          datetime     DEFAULT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)     NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `idx_sys_user_terminal_user` (`user_id`) USING BTREE
) COMMENT = '用户与终端的关联';

-- ----------------------------
-- Table structure for sys_user_company
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_user_company`
(
    `id`                 bigint(20) NOT NULL COMMENT '记录唯一ID',
    `sys_user_id`        bigint(20) NOT NULL COMMENT '用户ID',
    `ou_id`              bigint(20) NOT NULL COMMENT '公司ID',
    `ou_code`            varchar(255) DEFAULT NULL COMMENT '公司编码',
    `ou_name`            varchar(255) DEFAULT NULL COMMENT '公司名称',
    `bind_time`          datetime   NOT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(10)      DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_sys_user_company_user_id` (`sys_user_id`),
    KEY `idx_sys_user_company_ou_id` (`ou_id`)
) COMMENT ='用户与公司关联表';

-- ----------------------------
-- Table structure for sys_watermark_config
-- ----------------------------
CREATE TABLE IF NOT EXISTS `sys_watermark_config`
(
    `id`                 bigint(20)   NOT NULL COMMENT '记录唯一ID',
    `dynamic_field`      varchar(128) NOT NULL COMMENT '动态文字',
    `custom_field`       varchar(128) NOT NULL COMMENT '自定义文字',
    `field_size`         int(11)      NOT NULL COMMENT '文字大小',
    `color_size`         int(11)      NOT NULL COMMENT '颜色深浅',
    `rotation_angle`     int(11)      NOT NULL COMMENT '旋转角度',
    `stacking_deep`      int(11)      NOT NULL COMMENT '层叠深度',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    `font_size`          int(11)      DEFAULT NULL COMMENT '文字大小',
    `font_color`         int(11)      DEFAULT NULL COMMENT '颜色深浅',
    `rotate`             int(11)      DEFAULT NULL COMMENT '旋转角度',
    `dynamic_font`       varchar(128) DEFAULT NULL COMMENT '动态文字',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `UK_6o427gguo04v31r9g3msbxg6e` (`dynamic_field`) USING BTREE,
    UNIQUE INDEX `UK_60gw4xs9uqq3vcjyrkeceqfh1` (`custom_field`) USING BTREE,
    UNIQUE INDEX `UK_sacv4ku1gvp19qqdpclv8recp` (`field_size`) USING BTREE,
    UNIQUE INDEX `UK_sdci4r099jl9cyfo65fnopc7l` (`color_size`) USING BTREE,
    UNIQUE INDEX `UK_n27qsxfy5r7cfp4m2flgec5sm` (`rotation_angle`) USING BTREE,
    UNIQUE INDEX `UK_jckf23ishvdy8jx4iwtfybbgv` (`stacking_deep`) USING BTREE
) COMMENT = '系统水印配置';

-- ----------------------------
-- Table structure for undo_log
-- ----------------------------
CREATE TABLE IF NOT EXISTS `undo_log`
(
    `id`            bigint(20)   NOT NULL AUTO_INCREMENT COMMENT 'increment id',
    `branch_id`     bigint(20)   NOT NULL COMMENT 'branch transaction id',
    `xid`           varchar(128) NOT NULL COMMENT 'global transaction id',
    `context`       varchar(128) NOT NULL COMMENT 'undo_log context,such as serialization',
    `rollback_info` longblob     NOT NULL COMMENT 'rollback info',
    `log_status`    int(11)      NOT NULL COMMENT '0:normal status,1:defense status',
    `log_created`   datetime     NOT NULL COMMENT 'create datetime',
    `log_modified`  datetime     NOT NULL COMMENT 'modify datetime',
    PRIMARY KEY (`id`) USING BTREE,
    UNIQUE INDEX `ux_undo_log` (`xid`, `branch_id`) USING BTREE
) COMMENT = 'AT transaction mode undo table';

-- ----------------------------
-- Table structure for user_join_buid
-- ----------------------------
CREATE TABLE IF NOT EXISTS `user_join_buid`
(
    `id`                 bigint(20) NOT NULL AUTO_INCREMENT COMMENT '记录唯一ID',
    `userid`             int(11)      DEFAULT NULL COMMENT 'userid',
    `sec_buid`           int(11)      DEFAULT NULL COMMENT 'sec_buid',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)    NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE
);

-- ----------------------------
-- Table structure for user_join_userid
-- ----------------------------
CREATE TABLE IF NOT EXISTS `user_join_userid`
(
    `id`                 int(11) NOT NULL AUTO_INCREMENT,
    `userid`             int(11)      DEFAULT NULL,
    `sec_userid`         int(11)      DEFAULT NULL,
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime(6)  DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime(6)  DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11) NOT NULL COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '锁版本',
    PRIMARY KEY (`id`) USING BTREE,
    INDEX `userid` (`userid`, `sec_userid`) USING BTREE,
    INDEX `sec_userid` (`sec_userid`) USING BTREE,
    INDEX `create_user_id_index` (`create_user_id`) USING BTREE
);
